<?php
if (!defined('ABSPATH')) exit;

function wpsl_render_faq_page() {
	if (!current_user_can('manage_options')) return;
	?>
	<div class="wrap wpsl-faq">
		<h1>Castio Live &ndash; FAQ / Help</h1>
		<div style="margin:10px 0; display:flex; gap:10px; align-items:center; flex-wrap:wrap;">
			<label for="wpsl-faq-search" class="screen-reader-text">Search FAQ</label>
			<input type="search" id="wpsl-faq-search" placeholder="Search FAQ (keywords)" class="regular-text" style="min-width:280px;" />
			<span id="wpsl-faq-count" class="description"></span>
		</div>
		<div class="wpsl-faq-list">
		<details>
			<summary><span style="margin-right:6px">⏱️</span><strong>What is the minimum latency?</strong></summary>
			<div class="wpsl-faq-content">Premium supports latency as low as ~4 seconds. The free version targets ~10 seconds for reliable playback.</div>
		</details>
		<details>
			<summary><span style="margin-right:6px">🎥</span><strong>HLS vs WebRTC: what’s the difference?</strong></summary>
			<div class="wpsl-faq-content">WebRTC offers sub‑second delay but it’s resource‑intensive and suited for small calls; in practice it handles only a handful of viewers per publisher. HLS adds a few seconds of latency, but it’s HTTP‑based and scales to virtually unlimited viewers on typical hosting and CDNs.</div>
		</details>
		<details>
			<summary><span style="margin-right:6px">ℹ️</span><strong>Are there limits on storage, viewers, or chat participants?</strong></summary>
			<div class="wpsl-faq-content">No built-in limits. Capacity depends on your server resources (disk, CPU, memory) and configuration.</div>
		</details>
		<details>
			<summary><span style="margin-right:6px">ℹ️</span><strong>How many people can watch at the same time?</strong></summary>
			<div class="wpsl-faq-content">There is no fixed limit. Concurrency depends only on your server bandwidth and setup (unlike many WebRTC solutions that cap concurrent viewers).</div>
		</details>
		<details>
			<summary><span style="margin-right:6px">ℹ️</span><strong>Purchase license policy</strong></summary>
			<div class="wpsl-faq-content">One license = one domain name. A single license permits activation on one production domain. For additional domains, please purchase additional licenses.</div>
		</details>
		<details>
			<summary><span style="margin-right:6px">🌐</span><strong>What browsers can stream?</strong></summary>
			<div class="wpsl-faq-content">Streaming requires <code>MediaStreamTrackProcessor</code> and WebCodecs H.264 encoder. Use Chrome/Edge desktop or Android Chrome. iOS Safari and Firefox cannot stream.</div>
		</details>
		<details>
			<summary><span style="margin-right:6px">📱</span><strong>Can viewers watch on iOS?</strong></summary>
			<div class="wpsl-faq-content">Yes. Viewing works on all modern browsers including iOS Safari.</div>
		</details>
		<details>
			<summary><span style="margin-right:6px">💾</span><strong>Where are stream files stored?</strong></summary>
			<div class="wpsl-faq-content">Under <code>wp-content/uploads/wpsl/{stream_id}</code>. Enable "Save recording" to keep files and auto-generate a replay playlist.</div>
		</details>
		<details>
			<summary><span style="margin-right:6px">🔒</span><strong>How does password protection work?</strong></summary>
			<div class="wpsl-faq-content">Viewers enter a password; a signed cookie grants access for 24 hours.</div>
		</details>
		<details>
			<summary><span style="margin-right:6px">💳</span><strong>How does Stripe paywall work?</strong></summary>
			<div class="wpsl-faq-content">Uses Stripe Checkout for one-time payment, then verifies the session on return to unlock access.</div>
		</details>
		<details>
			<summary><span style="margin-right:6px">📊</span><strong>Where are Sale Reports?</strong></summary>
			<div class="wpsl-faq-content">
				Open <em>Castio Live &rarr; Sale Reports</em> to see per‑stream sales.
				<ul style="list-style:disc;margin-left:20px;">
					<li>Filter by date range using Start/End selectors.</li>
					<li>Totals banner shows overall sales count and gross by currency.</li>
					<li>Each stream row shows configured price, sales, gross, buyers (emails), and last sale time.</li>
					<li>Data fetches the latest 100 Stripe Checkout sessions in the range. Click <em>Refresh</em> to update.</li>
				</ul>
				<p class="description">Numbers exclude Stripe fees; use the Stripe Dashboard for fee‑inclusive totals.</p>
			</div>
		</details>
		<details>
			<summary><span style="margin-right:6px">🧩</span><strong>Integrate Stripe &ndash; Step by Step</strong></summary>
			<div class="wpsl-faq-content">
				<ol style="margin:8px 0 0 20px;">
					<li>Go to Stripe Dashboard &rarr; Developers &rarr; API keys.</li>
					<li>Copy your <em>Publishable key</em> (starts with <code>pk_</code>) and <em>Secret key</em> (starts with <code>sk_</code>).</li>
					<li>In WordPress, open Castio Live &rarr; Settings and paste keys into the fields.</li>
					<li>Optionally set the default currency (ISO code like <code>usd</code>, <code>eur</code>).</li>
					<li>On the stream admin page, choose Video access &rarr; Paywall and set price/currency.</li>
					<li>Share the viewer URL. Viewers pay via Stripe Checkout and are redirected back with access unlocked.</li>
				</ol>
			</div>
		</details>
		<details>
			<summary><span style="margin-right:6px">✉️</span><strong>How do email invitations work?</strong></summary>
			<div class="wpsl-faq-content">
				<ol style="margin:8px 0 0 20px;">
					<li>On the <em>Castio Live</em> page, check <em>Invite by email</em>.</li>
					<li>Click <em>Add users to be invited</em> to open the picker. Select existing users or add emails manually, then <em>Save Selection</em>.</li>
					<li>Optionally click <em>Send Preview to Me</em> from the modal to test the email.</li>
					<li>Click <em>Start</em> to begin streaming; invites send in the background to selected recipients.</li>
				</ol>
				<p>Customize the subject and HTML template under <em>Castio Live &rarr; Settings &rarr; Invitation Email</em>. Available placeholders: <code>{{viewer_url}}</code>, <code>{{stream_id}}</code>, <code>{{stream_title}}</code>, <code>{{start_time}}</code>.</p>
			</div>
		</details>
		<details>
			<summary><span style="margin-right:6px">🛡️</span><strong>How to moderate chat?</strong></summary>
			<div class="wpsl-faq-content">Admins can delete messages and ban users from the sidebar user list.</div>
		</details>
		<details>
			<summary><span style="margin-right:6px">🎞️</span><strong>Where are Recorded Videos?</strong></summary>
			<div class="wpsl-faq-content">Open <em>Castio Live &rarr; Recorded Videos</em> to browse replays. You can search by name/ID, preview HLS, rename the title inline, and bulk delete old sessions. Replays are stored under <code>uploads/wpsl/{id}</code> as <code>vod.m3u8</code>.</div>
		</details>
		<details>
			<summary><span style="margin-right:6px">🔗</span><strong>How do I create a Viewer page?</strong></summary>
			<div class="wpsl-faq-content">On the Castio Live page, click <em>Auto-create Viewer Page</em> after creating a stream. Alternatively, embed manually with <code>[wpsl_viewer stream="123"]</code>. Options: <code>chat="0|1"</code>, <code>poll="1.5"</code>. You can also open an on-the-fly viewer at <code>/?wpsl_viewer=1&stream=123</code>.</div>
		</details>
		<details>
			<summary><span style="margin-right:6px">👥</span><strong>Online users (Presence)</strong></summary>
			<div class="wpsl-faq-content">The viewer reports presence periodically. Admins can query <code>/wp-json/wpsl/v1/presence/list?stream_id=123</code> and charts in the UI use this data. When <em>Other users can see user list</em> is enabled, a public list of names is exposed via <code>/wp-json/wpsl/v1/presence/public?stream_id=123</code>.</div>
		</details>
		<details>
			<summary><span style="margin-right:6px">🚦</span><strong>Chat rate limits</strong></summary>
			<div class="wpsl-faq-content">Server-side anti-flood is enabled: minimum interval between messages per IP per stream and a burst window cap. If users report blocked messages, slow the typing rate or reduce burstiness.</div>
		</details>
		<details>
			<summary><span style="margin-right:6px">🧼</span><strong>Reset chat table</strong></summary>
			<div class="wpsl-faq-content">Use WP-CLI: <code>wp db query "TRUNCATE TABLE $(wp db prefix)wpsl_chat;"</code>. Back up first; this permanently deletes all chat history.</div>
		</details>
		<details>
			<summary><span style="margin-right:6px">💳</span><strong>Stripe payment issues</strong></summary>
			<div class="wpsl-faq-content">
				<ul style="list-style:disc;margin-left:20px;">
					<li>Ensure <em>Castio Live &rarr; Settings</em> has valid <code>pk_</code> and <code>sk_</code> keys (test vs live).</li>
					<li>Price must be set on the stream when Paywall is selected.</li>
					<li>Viewer returns with <code>?session_id=...</code>; the plugin verifies status and unlocks access. If not redirecting, check site HTTPS and that the return URL loads publicly.</li>
					<li>Use Stripe Dashboard logs to inspect Checkout Session creation and status.</li>
				</ul>
			</div>
		</details>
		<details>
			<summary><span style="margin-right:6px">💡</span><strong>Tips</strong></summary>
			<div class="wpsl-faq-content">
				<ul style="list-style:disc;margin-left:20px;">
					<li>Use 2&ndash;4s latency for a good balance of quality and stability.</li>
					<li>Toggle "Save recording" to publish a VOD playlist when stopping.</li>
					<li>Auto-create a Viewer page for easy sharing and permalinks.</li>
				</ul>
			</div>
		</details>
		<details>
			<summary><span style="margin-right:6px">⏱️</span><strong>Live vs Replay</strong></summary>
			<div class="wpsl-faq-content">Replay is created when "Save recording" is enabled before starting. The recordings page lists both replay (vod.m3u8) and live playlists (index.m3u8). Viewer opens replay automatically when the URL ends with <code>#replay</code>.</div>
		</details>
		<details>
			<summary><span style="margin-right:6px">🧰</span><strong>Troubleshooting playback</strong></summary>
			<div class="wpsl-faq-content">If video doesn't start: verify the playlist URL loads, confirm server serves correct MIME types (m3u8: <code>application/vnd.apple.mpegurl</code>, m4s/mp4: <code>video/mp4</code>). For non-Safari browsers, hls.js is loaded automatically for previews.</div>
		</details>
		<details>
			<summary><span style="margin-right:6px">🧹</span><strong>Storage and cleanup</strong></summary>
			<div class="wpsl-faq-content">Use bulk delete on the recordings page to remove old sessions. Consider using a CDN if footprint grows. Only files under <code>uploads/wpsl/{id}</code> are touched by delete.</div>
		</details>
		<details>
			<summary><span style="margin-right:6px">🔐</span><strong>Security & privacy</strong></summary>
			<div class="wpsl-faq-content">Admin-only endpoints enforce capability checks and nonces. Password/paywall gate viewer access via signed cookies. Upload writes are restricted to per-stream folders only.</div>
		</details>
		<details>
			<summary><span style="margin-right:6px">🔑</span><strong>Logged-in Access</strong></summary>
			<div class="wpsl-faq-content">Enable <em>Only logged-in users can access video</em> on the Castio Live admin page to require viewers to sign in before watching. If WordPress registration is disabled, you can also check <em>Allow new users to register</em> to enable sign-ups site‑wide so new viewers can create accounts.</div>
		</details>
		</div>
		<p id="wpsl-faq-empty" class="description" style="display:none;">No matches found.</p>
		<script>
		(function(){
			function ready(fn){ if(document.readyState!=='loading') fn(); else document.addEventListener('DOMContentLoaded', fn); }
			ready(function(){
				var input = document.getElementById('wpsl-faq-search');
				var list = document.querySelector('.wpsl-faq-list');
				var empty = document.getElementById('wpsl-faq-empty');
				var count = document.getElementById('wpsl-faq-count');
				if (!input || !list) return;
				var items = Array.prototype.slice.call(list.querySelectorAll('details'));
				function norm(s){ return s.toLowerCase().replace(/[\u0300-\u036f]/g, ''); }
				function clearHighlights(el){
					var marks = el.querySelectorAll('mark.wpsl-hl');
					marks.forEach(function(m){ m.replaceWith(document.createTextNode(m.textContent)); });
				}
				function applyHighlights(det, q){
					if (!q) return;
					var re = new RegExp(q.replace(/[-\/\\^$*+?.()|[\]{}]/g,'\\$&'), 'gi');
					var walker = document.createTreeWalker(det, NodeFilter.SHOW_TEXT, {
						acceptNode: function(n){
							if (!n.nodeValue || !re.test(n.nodeValue)) return NodeFilter.FILTER_SKIP;
							re.lastIndex = 0;
							return NodeFilter.FILTER_ACCEPT;
						}
					}, false);
					var nodes = [];
					while (walker.nextNode()) nodes.push(walker.currentNode);
					nodes.forEach(function(textNode){
						var val = textNode.nodeValue; if (!re.test(val)) return; re.lastIndex = 0;
						var frag = document.createDocumentFragment();
						var last = 0; var m;
						while ((m = re.exec(val)) !== null) {
							if (m.index > last) frag.appendChild(document.createTextNode(val.slice(last, m.index)));
							var mark = document.createElement('mark'); mark.className = 'wpsl-hl'; mark.textContent = m[0]; frag.appendChild(mark);
							last = m.index + m[0].length;
						}
						if (last < val.length) frag.appendChild(document.createTextNode(val.slice(last)));
						textNode.replaceWith(frag);
					});
				}
				function search(){
					var q = norm(input.value.trim());
					var matches = 0;
					// clear previous highlights
					clearHighlights(list);
					items.forEach(function(d){
						var ok = !q || norm(d.textContent).indexOf(q) !== -1;
						d.style.display = ok ? '' : 'none';
						if (ok) { matches++; if (q) d.open = true; }
						else { d.open = false; }
					});
					// apply highlights to visible matches
					if (q) {
						items.forEach(function(d){ if (d.style.display !== 'none') applyHighlights(d, q); });
					}
					if (count) count.textContent = q ? (matches + ' match' + (matches===1?'':'es')) : '';
					if (empty) empty.style.display = (q && matches===0) ? '' : 'none';
				}
				input.addEventListener('input', search);
			});
		})();
		</script>
	<?php
}
